/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.util.HThreadGroup;
import com.ibm.hwmca.fw.util.TimeExpiredException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkRequest;
import com.ibm.hwmca.fw.util.WorkThread;
import java.util.ArrayList;

public class WorkThread
extends Thread {
    private static final String TRACE_MASKT = "XFRMWKTT";
    private static final String TRACE_MASKF = "XFRMWKTF";
    private String _name;
    private volatile boolean _runOnce;
    private volatile Thread _stopThread;
    private volatile boolean _threadSuspended;
    private volatile WorkRequest _requestAnchor;
    private volatile Object requestQueueLock = new Object();

    public static Throwable[] runSynchronously(Runnable[] targets, boolean daemon) {
        try {
            return WorkThread.runSynchronously(targets, daemon, 0L);
        }
        catch (TimeExpiredException e) {
            throw new RuntimeException("Probable coding error, this exception should never be thrown", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Throwable[] runSynchronously(Runnable[] targets, boolean daemon, long timeout) throws TimeExpiredException {
        block16: {
            block15: {
                Trace.trace("XFRMWKTT", "-> runSynchronously()");
                if (targets == null || targets.length == 0) {
                    throw new IllegalArgumentException("'targets' parameter must be non null and non empty");
                }
                workers = new ArrayList<.RsWorker>();
                isLock = new Object();
                returns = new Throwable[targets.length];
                i = 0;
                while (i < targets.length) {
                    worker = new .RsWorker(i, targets[i], isLock, returns, workers);
                    worker.setDaemon(daemon);
                    returns[i] = null;
                    var9_9 = isLock;
                    synchronized (var9_9) {
                        workers.add(worker);
                    }
                    worker.start();
                    ++i;
                }
                if (timeout <= 0L) break block15;
                waited = 0L;
                started = System.currentTimeMillis();
                var12_12 = isLock;
                synchronized (var12_12) {
                    if (true) ** GOTO lbl36
                }
            }
            var8_7 = isLock;
            synchronized (var8_7) {
                if (true) ** GOTO lbl46
            }
            {
                do {
                    try {
                        isLock.wait(timeout - waited);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    waited = System.currentTimeMillis() - started;
lbl36:
                    // 2 sources

                } while (!workers.isEmpty() && waited < timeout);
                if (!workers.isEmpty()) {
                    throw new TimeExpiredException("Time expired before all threads completed", returns);
                }
                break block16;
            }
            {
                do {
                    try {
                        isLock.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
lbl46:
                    // 3 sources

                } while (!workers.isEmpty());
            }
        }
        Trace.trace("XFRMWKTT", "<- runSynchronously()");
        return returns;
    }

    public static void invokeAsync(WorkListener listener, WorkPerformer performer, Object params, String threadName) {
        Trace.trace(TRACE_MASKT, "-> invokeAsync() for " + threadName);
        WorkThread worker = new WorkThread(threadName);
        worker.startWorkerOnce();
        worker.requestWork(listener, performer, null, params);
        Trace.trace(TRACE_MASKT, "<- invokeAsync");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Trace.trace(TRACE_MASKT, "-> WorkThread.run() for " + this._name);
        Thread thisThread = Thread.currentThread();
        while (this._stopThread == thisThread) {
            try {
                Trace.trace(TRACE_MASKF, "WorkThread is not stopped.  About to sleep()");
                Thread.sleep(100L);
                WorkThread workThread = this;
                synchronized (workThread) {
                    while ((this._threadSuspended || this._requestAnchor == null) && this._stopThread == thisThread) {
                        Trace.trace(TRACE_MASKF, "WorkThread is not stopped and suspended or no work.  About to wait()");
                        this.wait();
                    }
                }
                if (this._stopThread != thisThread) continue;
                while (this._requestAnchor != null) {
                    Trace.trace(TRACE_MASKF, "There is work on the queue.");
                    WorkRequest request = null;
                    Object object = this.requestQueueLock;
                    synchronized (object) {
                        request = this._requestAnchor;
                        this._requestAnchor = request.getNextRequest();
                    }
                    Trace.trace(TRACE_MASKF, "Processing work request " + request.getRequestId() + ".");
                    Object params = request.getParameters();
                    WorkPerformer performer = request.getPerformer();
                    Throwable requestEx = null;
                    Object retValue = null;
                    try {
                        retValue = performer.performWork(params);
                    }
                    catch (Throwable e) {
                        Trace.trace(TRACE_MASKF, "WorkPerformer for work request " + request.getRequestId() + "threw exception: " + e);
                        Trace.trace(TRACE_MASKF, e);
                        requestEx = e;
                    }
                    Trace.trace(TRACE_MASKF, "WorkPerformer completed for work request " + request.getRequestId() + ".");
                    WorkEvent event = new WorkEvent(performer, request.getRequestId(), requestEx, retValue);
                    request.getListener().workCompleted(event);
                    if (this._runOnce) {
                        this._stopThread = null;
                        Object object2 = this.requestQueueLock;
                        synchronized (object2) {
                            this._requestAnchor = null;
                            continue;
                        }
                    }
                    Thread.yield();
                }
                Trace.trace(TRACE_MASKF, "Work queue is empty");
            }
            catch (InterruptedException e) {
                Trace.trace(TRACE_MASKF, "WorkThread was interrupted.  Looping around again...");
            }
        }
        Trace.trace(TRACE_MASKT, "-> WorkThread.run()");
    }

    public WorkThread(String name) {
        super((ThreadGroup)HThreadGroup.defaultThreadGroup(), name + " (WorkThread)");
        this._name = name + " (WorkThread)";
        this._stopThread = this;
        this._threadSuspended = false;
        this._runOnce = false;
        this.setDaemon(true);
        Trace.trace(TRACE_MASKT, "<> WorkThread(" + name + ")");
    }

    private void startWorkerOnce() {
        this._runOnce = true;
        this.startWorker();
    }

    public synchronized void startWorker() {
        this.start();
    }

    public synchronized void stopWorker() {
        this._stopThread = null;
        this.notify();
    }

    public synchronized void suspendWorker() {
        if (!this._threadSuspended) {
            this._threadSuspended = true;
            this.notify();
        }
    }

    public synchronized void resumeWorker() {
        if (this._threadSuspended) {
            this._threadSuspended = false;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestWork(WorkListener listener, WorkPerformer performer, String requestId, Object params) {
        WorkRequest request = new WorkRequest(listener, performer, requestId, params);
        boolean bNotify = false;
        Object object = this.requestQueueLock;
        synchronized (object) {
            if (this._requestAnchor == null) {
                this._requestAnchor = request;
                bNotify = true;
            } else {
                this._requestAnchor.queueRequest(request);
            }
        }
        if (bNotify) {
            WorkThread workThread = this;
            synchronized (workThread) {
                this.notify();
            }
        }
    }
}

